﻿using System.Collections.Generic;
using System.Linq;

using VIRP.EFR.BO;
using VIRP.EFR.DAL;

namespace VIRP.EFR.BLL
{
    public class PatientImagingManager
    {
        private readonly AuthService AuthService;
        private readonly StudyService StudyService;

        public PatientImagingManager()
        {
            this.AuthService = new AuthService();
            this.StudyService = new StudyService();
        }

        public string GetApiToken(
            string currentUser, 
            int currentRegistryId, 
            bool? clearCache = null)
        {
            return this.AuthService
                .GetToken(currentUser, currentRegistryId, clearCache)
                .Value;
        }

        public IMAGE_ANALYSIS GetPatientImageAnalysis(string CURRENT_USER, int CURRENT_REGISTRY_ID, string patientIcn)
        {
            var db = new IMAGE_ANALYSISDB();

            return db.GetItemByPatientIcn(CURRENT_USER, CURRENT_REGISTRY_ID, patientIcn);
        }

        public string GetBodyPartsImaged(string CURRENT_USER, int CURRENT_REGISTRY_ID, int patientImageId)
        {
            var bodyParts = PATIENT_IMAGE_BODY_PARTManager.GetItemsByPatientImageId(CURRENT_USER, CURRENT_REGISTRY_ID, patientImageId);
            if (bodyParts != null && bodyParts.Any())
                return string.Join(",", bodyParts.Select(b => b.STD_IMAGE_BODY_PART_DESCRIPTION));

            return string.Empty;
        }

        public bool DeleteImageAnalysis(string CURRENT_USER, int CURRENT_REGISTRY_ID, string patientIcn)
        {
            var imageAnalysis = IMAGE_ANALYSISManager.GetItemByPatientIcn(CURRENT_USER, CURRENT_REGISTRY_ID, patientIcn);
            if (imageAnalysis != null)
                return IMAGE_ANALYSISManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, imageAnalysis.IMAGE_ANALYSIS_ID);

            return false;
        }

        public void InsertUpdateImageAnalysis(string CURRENT_USER, int CURRENT_REGISTRY_ID, IMAGE_ANALYSIS objSave)
        {
            IMAGE_ANALYSISManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        private void UpdateImageStudiesForPatient(string currentUser, int currentRegistryId, int patientId, string patientIcn)
        {
            var response = this.StudyService.GetStudiesForPatient(currentUser, currentRegistryId, patientIcn);
            if (response != null && response.Studies != null && response.Studies.Any())
                this.StudyService.InsertUpdateStudies(currentUser, currentRegistryId, patientId, response.Studies);
        }

        public int GetImagesForPatientCount(
            int PATIENT_ID,
            string PATIENT_ICN,
            int START_ROW,
            int MAX_ROWS,
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID)
        {
            return this.GetImagesForPatientCount(
                PATIENT_ID, CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public int GetImagesForPatientCount(
            int PATIENT_ID,
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID)
        {
            var db = new PatientImagingDB();

            return db.GetImagesForPatientCount(PATIENT_ID, CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public IEnumerable<PatientImageView> GetImagesForPatient(
            int PATIENT_ID,
            string PATIENT_ICN,
            int START_ROW,
            int MAX_ROWS,
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID)
        {
            var db = new PatientImagingDB();

            IEnumerable<PatientImageView> patientImages = db.GetImagesForPatient(PATIENT_ID, START_ROW, MAX_ROWS, CURRENT_USER, CURRENT_REGISTRY_ID);

            if (patientImages == null || !patientImages.Any())
            {
                this.UpdateImageStudiesForPatient(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID, PATIENT_ICN);
                patientImages = db.GetImagesForPatient(PATIENT_ID, START_ROW, MAX_ROWS, CURRENT_USER, CURRENT_REGISTRY_ID);
            }

            return patientImages;
        }
    }
}